 /* 'mrTexture.cpp' */

 /* Komplemetarny plik nagwka */
#include "mrTexture.h"

 /* Statyczne skadniki tekstury */
mrUInt32    mrTexture::m_iActiveTexture  = -1;
mrUInt32    mrTexture::m_iCurrentID      = 0;

 /* Konstruktor domylny */
mrTexture::mrTexture (void)
{
 m_pkD3DTexture = NULL;
 m_pkRawImage   = NULL;

 m_iHasAlpha    = mrFalse;
 m_iID          = 0;
}

 /* Destruktor domylny */
mrTexture::~mrTexture (void)
{
 if (m_pkD3DTexture != NULL)
 {
  m_pkD3DTexture->Release ();
  m_pkD3DTexture = NULL;
 }
 if (m_pkRawImage != NULL)
 {
  delete m_pkRawImage;
  m_pkRawImage   = NULL;
 }
}

 /* Tworzy tesktur */
mrError32 mrTexture::Create (mrRGBAImage * pkRawImage)
{
  /* Aktualizuje metody */
 m_iID = m_iCurrentID;
 m_iCurrentID ++;

  /* Ustawia obraz rdowy tekstury i aktualizuje tesktur Direct3D */
 SetRawImage (pkRawImage);

 return Update ();
}

 /* Aktualizuje tekstury Direct3D */
mrError32 mrTexture::Update (void)
{
 if (m_pkRawImage == NULL)
 {
  return mrErrorInvalidRawImage;
 }

 if (m_pkD3DTexture != NULL)
 {
  m_pkD3DTexture->Release ();
  m_pkD3DTexture = NULL;
 }
 
 m_iHasAlpha = mrTrue;
  /* Jestemy w trybie 32-bitowym */
 if (32 == mrScreen::GetSingleton ()->GetBitdepth ())
 {
   /* Prbujemy utworzy tekstur alfa */
  if (FAILED (mrScreen::GetSingleton ()->GetDevice ()->CreateTexture (
                   m_pkRawImage->GetWidth (),
                   m_pkRawImage->GetHeight (), 
                   0, 0,
                   D3DFMT_A8R8G8B8,
                   D3DPOOL_MANAGED,
                   &m_pkD3DTexture)) )
  {
    /* Jeeli si nie udao uyj dla tesktury formatu bufora tylnego */
   if (FAILED (mrScreen::GetSingleton ()->GetDevice ()->CreateTexture (
                    m_pkRawImage->GetWidth (),
                    m_pkRawImage->GetHeight (), 
                    0, 0,
                    (D3DFORMAT) mrScreen::GetSingleton ()->GetFormat (),
                    D3DPOOL_MANAGED,
                    &m_pkD3DTexture)) )
   {
    m_pkD3DTexture = NULL;
    m_iHasAlpha = mrFalse;
    return mrErrorCreateTexture;
   }
  }
 }
  /* Jestemy w trybie 16-bitowym */
 if (16 == mrScreen::GetSingleton ()->GetBitdepth ())
 {
   /* Prba utworzenia tekstury alfa */
  if (FAILED (mrScreen::GetSingleton ()->GetDevice ()->CreateTexture (
                   m_pkRawImage->GetWidth (),
                   m_pkRawImage->GetHeight (), 
                   0, 0,
                   D3DFMT_A4R4G4B4,
                   D3DPOOL_MANAGED,
                   &m_pkD3DTexture)) )
  {
   m_iHasAlpha = mrFalse;
    /* Jeeli si nie udao uyj dla tesktury formatu bufora tylnego */
   if (FAILED (mrScreen::GetSingleton ()->GetDevice ()->CreateTexture (
                    m_pkRawImage->GetWidth (),
                    m_pkRawImage->GetHeight (), 
                    0, 0,
                    (D3DFORMAT) mrScreen::GetSingleton ()->GetFormat (),
                    D3DPOOL_MANAGED,
                    &m_pkD3DTexture)) )
   {
    m_pkD3DTexture = NULL;
    return mrErrorCreateTexture;
   }
  }
 }

  /* Zablokuj tekstur */
 D3DLOCKED_RECT kLockedRect;
 m_pkD3DTexture->LockRect (0, &kLockedRect, NULL, 0);

  /* Wskaniki do zablokowanej tekstury */
 WORD * pi16TextureBuffer;
 DWORD * pi32TextureBuffer;

  /* Uzyj odpowiedniego wskanika w zalenoci od gbi */
 if (mrScreen::GetSingleton ()->GetBitdepth () == 16)
 {
   /* Rzutuj 16-bitowy wskanik, aby wskazywa na pierwszy piksel */
  pi16TextureBuffer = (WORD *) kLockedRect.pBits;
 }
 else 
 {
   /* Rzutuj 32-bitowy wskanik, aby wskazywa na pierwszy piksel */
  pi32TextureBuffer = (DWORD *) kLockedRect.pBits;
 }

  /* Wypenij powierzchni */
 mrUInt32 iX, iY;
 mrUInt32 iDepth;

  /* Pobierz gbi w bajtach i oblicz skok */
 iDepth = mrScreen::GetSingleton ()->GetBitdepth () / 8;
 mrUInt32 iPitch = kLockedRect.Pitch / iDepth;

 mrUInt8  iRed, iGreen, iBlue, iAlpha;
 mrUInt32 iColor;

 for (iY=0; iY < m_pkRawImage->GetHeight (); iY++)
 {
  for (iX=0; iX < m_pkRawImage->GetWidth (); iX++)
  {
    /* Pobierz komponenty koloru */
   iColor = m_pkRawImage->GetColor (iX, iY);

   iRed   = (mrUInt8)((iColor & 0xFF000000) >> 24);
   iGreen = (mrUInt8)((iColor & 0x00FF0000) >> 16);
   iBlue  = (mrUInt8)((iColor & 0x0000FF00) >> 8);
   iAlpha = (mrUInt8)((iColor & 0x000000FF));
 
    /* Zapisz kolor do bufora powierchni w zalenoci od trybu*/
   if (mrScreen::GetSingleton ()->GetBitdepth () == 16)
   {
    if (mrTrue == m_iHasAlpha)
    {
      pi16TextureBuffer [iX + iY * iPitch] = 
       (mrUInt16)((iAlpha * ((1 << 4)-1) / 255 << 12) | 
                  (iRed   * ((1 << 4)-1) / 255 << 8) | 
                  (iGreen * ((1 << 4)-1) / 255 << 4) | 
                  (iBlue  * ((1 << 4)-1) / 255 ));
    }
    else
    {
     if (mrScreen::GetSingleton ()->GetFormat () == D3DFMT_R5G6B5)
     {
      pi16TextureBuffer [iX + iY * iPitch] = 
       (mrUInt16)((iRed   * ((1 << 5)-1) / 255 << 11) | 
                  (iGreen * ((1 << 6)-1) / 255 << 5) | 
                  (iBlue  * ((1 << 5)-1) / 255 ));
     }
     if (mrScreen::GetSingleton ()->GetFormat () == D3DFMT_X1R5G5B5)
     {
      pi16TextureBuffer [iX + iY * iPitch] = 
       (mrUInt16)((iRed   * ((1 << 5)-1) / 255  << 10) |
                  (iGreen * ((1 << 5)-1) / 255  << 5) |
                  (iBlue  * ((1 << 5)-1) / 255 ));
     }
     if (mrScreen::GetSingleton ()->GetFormat () == D3DFMT_A1R5G5B5)
     {
      pi16TextureBuffer [iX + iY * iPitch] = 
       (mrUInt16)(((iAlpha > 0) ? 1 : 0 << 15) |
                   (iRed   * ((1 << 5)-1) / 255  << 10) |
                   (iGreen * ((1 << 5)-1) / 255  << 5) |
                   (iBlue  * ((1 << 5)-1) / 255 ));
     }
    }
   }
   else
   {
    pi32TextureBuffer [iX + iY * iPitch] = 
                   D3DCOLOR_ARGB (iAlpha, iRed, iGreen, iBlue);
   }
  }
 }

  /* Odblokuj */
 m_pkD3DTexture->UnlockRect (0);

 return mrNoError;
}

 /* Ustaw obraz rdowy powierchni */
void mrTexture::SetRawImage (mrRGBAImage * pkRawImage)
{
 if (m_pkRawImage == NULL)
 {
  m_pkRawImage = new mrRGBAImage ();
 }

 m_pkRawImage->SetWidth (pkRawImage->GetWidth ());
 m_pkRawImage->SetHeight (pkRawImage->GetHeight ());
 m_pkRawImage->SetImageBuffer (pkRawImage->GetImageBuffer ());
}

 /* Zwraca obraz rdowy powierzchni */
mrRGBAImage * mrTexture::GetRawImage (void)
{
 return m_pkRawImage;
}

 /* Ustawia tekstur aktywn Direct3D */
void mrTexture::SetActiveTexture (void)
{
 if (m_iActiveTexture != m_iID)
 {
  mrScreen::GetSingleton ()->GetDevice ()->SetTexture (0, m_pkD3DTexture);
  m_iActiveTexture = m_iID;
 }
}

 /* Zwraca identyfikator teskstury */
mrUInt32 mrTexture::GetID (void)
{
 return m_iID;
}

 /* Zwraca aktywn tekstur Direct3D */
mrUInt32 mrTexture::GetActiveTexture (void)
{
 return m_iActiveTexture;
}
